<div class="eltdf-team-holder <?php echo esc_attr($holder_classes); ?>">
	<div class="eltdf-team-inner">
		<?php if ($team_image !== '') { ?>
			<div class="eltdf-team-image">
                <?php echo wp_get_attachment_image($team_image, 'full'); ?>
                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px"
                     y="0px" width="250px" height="241.25px" viewBox="0 0 250 241.25" enable-background="new 0 0 250 241.25" xml:space="preserve">
                <path fill="none" stroke="#85A2BB" stroke-miterlimit="10" d="M201.003,32.4C162.782-1.724,103.915-8.698,59.763,18
                    C16.132,44.386-7.596,97.997,4.534,147.83c11.795,48.471,53.951,86.862,103.958,91.538c51.938,4.854,103.266-25.332,122.811-73.915
                    c8.049-20.008,10.756-42.184,7.418-63.513"/>
                <g>
                    <path fill="#9AB5C7" d="M193.551,27.047c1.49,1.217,2.065,3.039,5.92,7.03c3.856,3.993,14.563,5.062,18.797,3.816
                        c4.231-1.248,7.378-3.222,2.428-5.914c-4.952-2.696-7.373-3.998-12.537-4.47c-5.166-0.46-6.95,0.996-10.02-0.853
                        C195.067,24.809,192.278,26.006,193.551,27.047z"/>
                    <path fill="#85A2BB" d="M202.783,33.395c0.436,0.913,0.317,1.955-0.171,2.776c-1.256-0.582-2.347-1.271-3.142-2.094
                        c-3.854-3.991-4.43-5.813-5.92-7.03c-1.273-1.041,1.517-2.238,4.588-0.39c2.002,1.205,3.472,1.004,5.668,0.853
                        c-0.024,0.245-0.13,0.527-0.402,0.853C201.637,30.475,201.664,31.041,202.783,33.395z"/>
                    <path fill="#9DBDC2" d="M218.268,37.894c-2.292,0.672-6.48,0.663-10.454-0.115c1.669-1.482,7.161-2.736,4.873-5.833
                        c-0.408-0.553-5.312-3.509-2.436-4.075c0.107-0.02,0.236-0.008,0.351-0.028c3.614,0.641,5.999,1.902,10.094,4.138
                        C225.646,34.672,222.499,36.646,218.268,37.894z"/>
                    <path fill="#365E63" d="M193.613,25.994c4.288,2.615,8.806,5.306,13.762,6.123c0.359,0.067,0.348,0.264-0.017,0.209
                        c-5.067-0.634-9.764-3.041-14.1-5.707C193.203,26.39,193.334,26.163,193.613,25.994z"/>
                </g>
                <g>
                    <path fill="#7999B4" d="M239.177,108.773c-1.661-2.785-1.803-7.979-4.209-14.039c-2.416-6.05-2.53-14.051,1.106-18.888
                        c3.639-4.844,3.783-9.451,5.588-4.622c1.811,4.83,8.231,8.79,6.048,19.025c-2.186,10.241-4.277,9.464-5.585,12.18
                        C240.82,105.148,241.082,111.969,239.177,108.773z"/>
                    <path fill="#668AAB" d="M238.996,90.422c1.042,2.527,2.697,7.115,5.133,2.733c0.964-1.758,2.51-2.055,3.171-1.093
                        c-0.697,2.853-1.376,4.655-2.018,5.911c-2.196,2.721-5.361,5.722-6.98,8.71c-0.932-2.942-1.433-7.169-3.334-11.949
                        c-0.612-1.528-1.07-3.184-1.366-4.889c0.081-0.184,0.146-0.381,0.252-0.553C235.427,86.737,238.149,88.368,238.996,90.422z"/>
                    <path fill="#8CABBF" d="M241.661,71.225c1.73,4.622,7.667,8.458,6.269,17.744c-2.109-4.291-3.982-11.279-9.445-5.412
                        c-3.535,3.789-4.385,0.462-4.322-3.912c0.457-1.381,1.073-2.682,1.911-3.798C239.712,71.003,239.856,66.396,241.661,71.225z"/>
                    <path fill="#365E63" d="M240.882,88.158c0.027,2.301-0.269,4.663-0.41,6.943c-0.403,4.575-0.165,9.225-0.13,13.836
                        c0.003,0.187-0.009,0.327-0.016,0.481c-0.233,0.286-0.527,0.233-0.931-0.326c-0.004-0.047-0.012-0.078-0.008-0.125
                        c-0.058-4.632-0.197-9.277,0.355-13.962c0.228-2.344,0.58-4.567,0.636-6.893c-0.015-2.264-0.152-4.561-0.467-6.829
                        c-0.085-0.641,0.17-0.695,0.278-0.048C240.573,83.519,240.792,85.817,240.882,88.158z"/>
                </g>
                </svg>
			</div>
		<?php } ?>
		<div class="eltdf-team-info">
			<?php if ($team_name !== '') { ?>
				<<?php echo esc_attr($team_name_tag); ?> class="eltdf-team-name" <?php echo theaisle_elated_get_inline_style($team_name_styles); ?>><?php echo esc_html($team_name); ?></<?php echo esc_attr($team_name_tag); ?>>
			<?php } ?>
			<?php if ($team_position !== "") { ?>
				<span class="eltdf-team-position" <?php echo theaisle_elated_get_inline_style($team_position_styles); ?>><?php echo esc_html($team_position); ?></span>
			<?php } ?>
			<?php if ($team_text !== "") { ?>
				<p class="eltdf-team-text" <?php echo theaisle_elated_get_inline_style($team_text_styles); ?>><?php echo esc_html($team_text); ?></p>
			<?php } ?>
			<?php if (!empty($team_social_icons)) { ?>
				<div class="eltdf-team-social-holder">
					<?php foreach( $team_social_icons as $team_social_icon ) { ?>
						<span class="eltdf-team-icon"><?php echo wp_kses_post($team_social_icon); ?></span>
					<?php } ?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>