<?php

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Eltdf_Uncovering_Sections extends WPBakeryShortCodesContainer {}
	class WPBakeryShortCode_Eltdf_Uncovering_Sections_Item extends WPBakeryShortCodesContainer {}
}

if ( ! function_exists( 'theaisle_core_add_uncovering_sections_shortcodes' ) ) {
	function theaisle_core_add_uncovering_sections_shortcodes( $shortcodes_class_name ) {
		$shortcodes = array(
			'TheAisleCore\CPT\Shortcodes\UncoveringSections\UncoveringSections',
			'TheAisleCore\CPT\Shortcodes\UncoveringSections\UncoveringSectionsItem'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	add_filter( 'theaisle_core_filter_add_vc_shortcode', 'theaisle_core_add_uncovering_sections_shortcodes' );
}

if ( ! function_exists( 'theaisle_core_set_uncovering_sections_custom_style_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom css style for full screen sections holder shortcode
	 */
	function theaisle_core_set_uncovering_sections_custom_style_for_vc_shortcodes( $style ) {
		$current_style = '.vc_shortcodes_container.wpb_eltdf_uncovering_sections_item { 
			background-color: #f4f4f4; 
		}';
		
		$style .= $current_style;
		
		return $style;
	}
	
	add_filter( 'theaisle_core_filter_add_vc_shortcodes_custom_style', 'theaisle_core_set_uncovering_sections_custom_style_for_vc_shortcodes' );
}

if ( ! function_exists( 'theaisle_core_set_uncovering_sections_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for full screen sections holder shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function theaisle_core_set_uncovering_sections_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-uncovering-sections';
		$shortcodes_icon_class_array[] = '.icon-wpb-uncovering-sections-item';
		
		return $shortcodes_icon_class_array;
	}
	
	add_filter( 'theaisle_core_filter_add_vc_shortcodes_custom_icon_class', 'theaisle_core_set_uncovering_sections_icon_class_name_for_vc_shortcodes' );
}

if ( ! function_exists( 'theaisle_core_set_uncovering_sections_header_top_custom_styles' ) ) {
    /**
     * Function that set custom icon class name for full screen sections holder shortcode to set our icon for Visual Composer shortcodes panel
     */
    function theaisle_core_set_uncovering_sections_header_top_custom_styles() {
        $top_header_height = theaisle_elated_options()->getOptionValue( 'top_bar_height' );

        if ( ! empty( $top_header_height ) ) {
            echo theaisle_elated_dynamic_css( '.eltdf-uncovering-section-on-page:not(.eltdf-header-bottom).eltdf-header-top-enabled .eltdf-top-bar', array( 'top' => '-' . theaisle_elated_filter_px( $top_header_height ) . 'px' ) );
            echo theaisle_elated_dynamic_css( '.eltdf-uncovering-section-on-page:not(.eltdf-header-bottom).eltdf-header-top-enabled:not(.eltdf-sticky-header-appear) .eltdf-page-header', array( 'top' => theaisle_elated_filter_px( $top_header_height ) . 'px' ) );
        }
    }

    add_action( 'theaisle_elated_action_style_dynamic', 'theaisle_core_set_uncovering_sections_header_top_custom_styles' );
}

if ( ! function_exists( 'theaisle_core_register_uncovering_sections_scripts' ) ) {
	/**
	 * Function that register scripts for vertical split slider shortcode
	 */
	function theaisle_core_register_uncovering_sections_scripts( ) {

		wp_register_script( 'curtain', THEAISLE_CORE_SHORTCODES_URL_PATH . '/uncovering-sections/assets/js/plugins/curtain.js', array( 'jquery' ), false, true );

	}

	add_action( 'theaisle_elated_action_enqueue_third_party_scripts', 'theaisle_core_register_uncovering_sections_scripts' );
}