(function($) {
	'use strict';
	
	var workflow = {};
	eltdf.modules.workflow = workflow;
	
	workflow.eltdfWorkflow = eltdfWorkflow;
	
	
	workflow.eltdfOnDocumentReady = eltdfOnDocumentReady;
	
	$(document).ready(eltdfOnDocumentReady);
	$(window).on('load', eltdfOnWindowLoad);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function eltdfOnDocumentReady() {
		eltdfWorkflow();
	}
	
	/**
	 All functions to be called on $(document).ready() should be in this function
	 */
	function eltdfOnWindowLoad() {
		eltdfElementorWorkflow();
	}
	
	
	/**
	 * Elementor
	 */
	function eltdfElementorWorkflow(){
		$(window).on('elementor/frontend/init', function () {
			elementorFrontend.hooks.addAction( 'frontend/element_ready/eltdf_workflow.default', function() {
				eltdfWorkflow();
			} );
		});
	}
	
	function eltdfWorkflow() {
		var workflowShortcodes = $('.eltdf-workflow');
		if (workflowShortcodes.length) {
			workflowShortcodes.each(function () {
				var workflowShortcode = $(this);
				if (workflowShortcode.hasClass('eltdf-workflow-animate')) {
					var workflowItems = workflowShortcode.find('.eltdf-workflow-item');
					
					workflowShortcode.appear(function () {
						workflowShortcode.addClass('eltdf-appeared');
						setTimeout(function () {
							workflowItems.each(function (i) {
								var workflowItem = $(this);
								setTimeout(function () {
									workflowItem.addClass('eltdf-appeared');
								}, 350 * i);
							});
						}, 350);
					}, {accX: 0, accY: eltdfGlobalVars.vars.eltdfElementAppearAmount});
					
				}
			});
		}
	}
	
})(jQuery);