<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
	$data = $args['data'];
?>

<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><?php echo esc_html( $data['title'] ); ?></title>
		<style type="text/css">
			<?php
				echo $data['css'];
			?>
		</style>
	</head>
	<body>
		<!-- Header -->
		<table class="head container">
			<tr>
				<td class="header">
					<?php if ( $data['logo_url'] ): ?>
						<img src="<?php echo esc_url( $data['logo_url'] ); ?>" alt="<?php echo esc_attr( $data['logo_alt'] ); ?>">
					<?php endif; ?>
				</td>
				<td class="shop-info">
					<div class="shop-name">
						<h2><?php echo esc_html( $data['shop_name'] ); ?></h2>
					</div>
					<div class="shop-address"><?php echo esc_html( $data['shop_address'] ); ?></div>
				</td>
			</tr>
		</table>
		<?php if ( $data['title'] ): ?>
		<h1 class="document-type-label">
			<?php echo esc_html( $data['title'] ); ?>
		</h1>
		<?php endif; ?>
		<!-- Booking -->
		<table class="booking-data-addresses">
			<tr>
				<td class="booking-customer">
					<table>
						<?php if ( $data['customer_name'] ): ?>
							<tr class="billing-name">
								<th><?php echo esc_html( $data['customer_name'] ); ?></th>
							</tr>
						<?php endif; ?>
						<?php if ( $data['customer_phone'] ): ?>
							<tr class="billing-phone">
								<th>
									<a href="tel:<?php echo esc_attr( preg_replace( "/[^0-9]/", "", $data['customer_phone'] )); ?>">
										<?php echo esc_html( $data['customer_phone'] ); ?>
									</a>
								</th>
							</tr>
						<?php endif; ?>
						<?php if ( $data['customer_email'] ): ?>
							<tr class="billing-email">
								<th>
									<a href="mailto:<?php echo esc_attr( $data['customer_email'] ); ?>">
										<?php echo esc_html( $data['customer_email'] ); ?>
									</a>
								</th>
							</tr>
						<?php endif; ?>
						<?php if ( $data['customer_address'] ): ?>
							<tr class="billing-address">
								<th><?php echo esc_html( $data['customer_address'] ); ?></th>
							</tr>
						<?php endif; ?>
					</table>
				</td>
				<td class="booking-info"></td>
				<td class="booking-data">
					<table>
						<?php if ( $data['booking_number'] ) : ?>
							<tr class="booking-number">
								<th><?php esc_html_e( 'Booking Number:', 'eventlist' ); ?></th>
								<td><?php printf( esc_html__( '#%s' ), $data['booking_number'] ); ?></td>
							</tr>
						<?php endif; ?>
						<?php if ( $data['event_calendar'] ) : ?>
							<tr class="event_calendar">
								<th><?php esc_html_e( 'Event Calendar: ', 'eventlist' ); ?></th>
								<td><?php echo esc_html( $data['event_calendar'] ); ?></td>
							</tr>
						<?php endif; ?>
						<?php if ( $data['payment_method'] ) : ?>
							<tr class="payment-method">
								<th><?php esc_html_e( 'Payment Method:', 'eventlist' ); ?></th>
								<td><?php echo esc_html( $data['payment_method'] ); ?></td>
							</tr>
						<?php endif; ?>
						<?php if ( $data['booking_status'] ) : ?>
							<tr class="booking-status">
								<th><?php esc_html_e( 'Booking Status:', 'eventlist' ); ?></th>
								<td><?php echo esc_html( $data['booking_status'] ); ?></td>
							</tr>
						<?php endif; ?>
					</table>			
				</td>
			</tr>
		</table>
		<!-- Cart -->

		<?php if ( $data['event_name'] && $data['event_link'] ): ?>
		<h3 class="event">
			<span class="label"><?php esc_html_e( 'Event Name:', 'eventlist' ); ?></span>
			<span class="link">
				<a href="<?php echo esc_url( $data['event_link'] ); ?>" target="_blank">
					<?php echo esc_html( $data['event_name'] ); ?>
				</a>
			</span>
		</h3>
		<?php endif; ?>
		<table class="cart-detail">
			<thead>
				<tr>
					<th class="ticket"><?php esc_html_e( 'Ticket', 'eventlist' ); ?></th>
					<th class="quantity"><?php esc_html_e( 'Quantity', 'eventlist' ); ?></th>
					<th class="price"><?php esc_html_e( 'Price', 'eventlist' ); ?></th>
					<th class="total"><?php esc_html_e( 'Total', 'eventlist' ); ?></th>
				</tr>
			</thead>
			<tbody>
			<?php if ( ! empty( $data['cart_details'] ) && is_array( $data['cart_details'] ) ): ?>
				<?php foreach ( $data['cart_details'] as $cart_item ) :
					$item_qty = isset( $cart_item['qty'] ) && absint( $cart_item['qty'] ) ? absint( $cart_item['qty'] ) : 1;
					?>
					<?php if ( isset( $cart_item['data_person'] ) && $cart_item['data_person'] ): ?>
						<?php foreach ($cart_item['data_person'] as $k => $val): ?>

							<?php if ( $val['qty'] ): ?>
								<tr class="cart-item">
									<td class="ticket">
										<span class="item-name"><?php echo esc_html( $cart_item['id'] . ' - ' . $val['name'] ); ?></span>
									</td>
									<td class="quantity">
										<span class="item-number"><?php echo esc_html( $val['qty'] ); ?></span>
									</td>
									<td class="price">
										<?php echo el_pdf_price( (float)$val['price'] ); ?>
									</td>
									<td class="total">
										<?php echo el_pdf_price( $cart_item['price'] * $item_qty ); ?>
									</td>
								</tr>
							<?php endif; ?>
							
						<?php endforeach; ?>
					<?php else: ?>
					<tr class="cart-item">
						<td class="ticket">
							<?php if ( isset( $cart_item['name'] ) && $cart_item['name'] ): ?>
								<span class="item-name"><?php echo esc_html( $cart_item['name'] ); ?></span>
							<?php else: ?>
								<?php if ( isset( $cart_item['id'] ) && $cart_item['id'] ): ?>
									<span class="item-name"><?php echo esc_html( $cart_item['id'] ); ?></span>
								<?php endif; ?>
							<?php endif; ?>
						</td>
						<td class="quantity">
							<?php if ( isset( $cart_item['qty'] ) && $cart_item['qty'] ): ?>
								<span class="item-number"><?php echo esc_html( $cart_item['qty'] ); ?></span>
								<?php if ( isset( $cart_item['seat'] ) && $cart_item['seat'] && is_array( $cart_item['seat'] ) ): ?>
									<span class="item-seat">
										<?php echo ' - '.esc_html( implode( ', ', $cart_item['seat'] ) ); ?>
									</span>
								<?php endif; ?>
							<?php else: ?>
								<span class="item-number">1</span>
							<?php endif; ?>
						</td>
						<td class="price">
							<?php echo el_pdf_price( $cart_item['price'] ); ?>
						</td>
						<td class="total">
							<?php echo el_pdf_price( $cart_item['price'] * $item_qty ); ?>
						</td>
					</tr>
					<?php endif; ?>
				<?php endforeach;
			endif; ?>

			<?php if ( ! empty( $data['extra_service'] ) ): ?>
				<?php foreach ( $data['extra_service'] as $val ): ?>
					<?php if ( $val['qty'] > 0 ): ?>
						<tr class="cart-item">
							<td class="extra-item">
								<span class="item-name"><?php echo esc_html( $val['name'] ); ?></span>
							</td>
							<td class="quantity">
								<span class="item-number"><?php echo esc_html( $val['qty'] ); ?></span>
							</td>
							<td class="price">
								<span class="item-number"><?php echo el_pdf_price( $val['price'] ); ?></span>
							</td>
							<td class="total">
								<span class="item-number"><?php echo el_pdf_price( $val['price'] * $val['qty'] ); ?></span>
							</td>
						</tr>
					<?php endif; ?>

				<?php endforeach; ?>
			<?php endif; ?>
			</tbody>
			<tfoot>
				<tr class="no-borders">
					<td class="no-borders"></td>
					<td class="no-borders"></td>
					<td class="no-borders">
						<table class="totals">
							<tfoot>
								<?php if ( $data['subtotal'] ): ?>
									<tr>
										<th class="subtotal"><?php esc_html_e( 'Subtotal', 'eventlist' ); ?></th>
										<td class="price">
											<span><?php echo el_pdf_price( $data['subtotal'] + floatval( $data['discount'] ) - floatval( $data['system_fee'] ) ); ?></span>
										</td>
									</tr>
								<?php endif; ?>
								<?php if ( $data['discount'] ): ?>
									<tr class="discount">
										<th class="label"><?php esc_html_e( 'Discount', 'eventlist' ); ?></th>
										<td class="price">
											<span><?php printf( '-%s (%s)', el_pdf_price( $data['discount'] ), $data['coupon'] ); ?></span>
										</td>
									</tr>
								<?php endif; ?>
								<?php if ( $data['tax'] ): ?>
									<tr class="tax">
										<th class="label"><?php esc_html_e( 'Tax', 'eventlist' ); ?></th>
										<td class="price">
											<span><?php echo el_pdf_price( $data['tax'] ); ?></span>
										</td>
									</tr>
								<?php endif; ?>
								<?php if ( $data['system_fee'] ): ?>
									<tr class="tax">
										<th class="label"><?php esc_html_e( 'System fee', 'eventlist' ); ?></th>
										<td class="price">
											<span><?php echo el_pdf_price( $data['system_fee'] ); ?></span>
										</td>
									</tr>
								<?php endif; ?>
								<?php if ( $data['total'] ): ?>
									<tr class="total">
										<th class="label"><?php esc_html_e( 'Total', 'eventlist' ); ?></th>
										<td class="price">
											<span><?php echo el_pdf_price( $data['total'] ); ?></span>
										</td>
									</tr>
								<?php endif; ?>
							</tfoot>
						</table>
					</td>
				</tr>
			</tfoot>
		</table>
		<div class="bottom-spacer"></div>
		<?php if ( $data['footer'] ): ?>
			<div id="footer">
				<?php echo $data['footer']; ?>
			</div>
		<?php endif; ?>
	</body>
</html>